<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(102, 0, 0, 0.5), rgba(102, 0, 0, 0.5)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Honorable Judges</h1>
        <p>The Justices presiding over the Civil Appellate High Court of the Republic.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background: #fff;">
    
    <div class="section-header" style="margin-bottom: 40px; text-align: center;">
        <p class="sub-title" style="color:var(--gold-accent); text-transform:uppercase; letter-spacing:2px; font-size:0.9rem;">The Bench</p>
        <h2 style="color:var(--primary-color); font-size:2.2rem;">Judges of the <span style="font-family:'Playfair Display', serif; color:var(--gold-accent); font-style:italic;">Civil Appellate High Court</span></h2>
        <div class="gold-divider" style="width:60px; height:4px; background-color:var(--gold-accent); margin: 15px auto;"></div>
    </div>

    <div class="judges-container" style="background: white; padding: 40px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color);">
        
        <div class="judges-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 40px;">
            <ul class="judge-list" style="list-style: none;">
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice A.B.C. Perera (President of the Court)</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice S.D. Silva</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice K.M. Fernando</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice R.A. Jayasinghe</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice M.N. Peiris</li>
            </ul>

            <ul class="judge-list" style="list-style: none;">
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice K.L.M. Wickramasinghe</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice S.P. Ariyaratne</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice V.T. Thamilmaran</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice H.E. Weerakoon</li>
                <li style="margin-bottom: 15px; border-bottom: 1px solid #eee; padding-bottom: 10px;"><i class="fas fa-arrow-right" style="color: var(--gold-accent); margin-right: 10px;"></i> Hon. Justice G.H.J. Ratnayake</li>
            </ul>
        </div>

    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>